package com.company.mock;

import com.company.exceptions.DuplicatedDataException;
import com.company.model.*;

import java.util.List;
import java.util.Random;

public class MockData {
    private int ENROLLS_NR = 5;
    private int LECTURES_NR = 5;
    private String[] name_profs = {"Abrilina Décima Nona Caçapavana Piratininga de Almeida","Acheropita Papazone","Adalgamir Marge","Adegesto Pataca","Adoração Arabites","Aeronauta Barata","Agrícola Beterraba Areia","Agrícola da Terra Fonseca","Alce Barbuda","Aldegunda Carames More","Aleluia Sarango","Alfredo Prazeirozo Texugueiro","Alma de Vera","Amado Amoroso","Amável Pinto","Amazonas Rio do Brasil Pimpão","América do Sul Brasil de Santana","Amin Amou Amado","Amor de Deus Rosales Brasil","Anatalino Reguete","Antônio Americano do Brasil Mineiro","Antonio Buceta Agudim","Antonio Camisão","Antonio Dodói","Antonio Manso Pacífico de Oliveira Sossegado","Antonio Melhorança","Antônio Morrendo das Dores","Antonio Noites e Dias","Antônio P. Testa","Antonio Pechincha","Antônio Querido Fracasso","Antonio Treze de Junho de Mil Novecentos e Dezessete","Antônio Veado Prematuro","Apurinã da Floresta Brasileira","Araci do Precioso Sangue","Argentino Argenta","Aricléia Café Chá","Armando Nascimento de Jesus","Arquiteclínio Petrocoquínio de Andrade","Asteróide Silverio","Ava Gina","Bananéia Oliveira de Deus","Bandeirante do Brasil Paulistano","Barrigudinha Seleida","Bende Sande Branquinho Maracajá","Benedito Autor da Purificação","Benedito Camurça Aveludado","Benedito Frôscolo Jovino de Almeida Aimbaré Militão de Souza","Baruel de Itaparica Boré Fomi de Tucunduvá","Benigna Jarra"};
    private String[] initial_profs = {"ADNA","AAPP","ARME","AOPC","AOAS","AABA","ABAA","ATFA","AEBA","ACME","AASO","APTO","AAVA","AOAO","ALPO","ARBP","ASBS","AAAO","ADRB","AORE","AABM","ABAM","AOCO","AODI","AMPS","AMRA","AMDS","ANDS","APTA","AOPA","AQFO","AMND","AVPO","AFBA","APSE","AOAA","ACCA","ANJS","APAE","AESO","AAGA","BODS","BBPO","BASA","BSBM","BAPO","BCAO","BFJA","BIBT","BAJA"};
    private String[] name_students = {"Benvindo Viola","Bispo de Paris","Bizarro Assada","Boaventura Torrada","Bom Filho Persegonha","Brandamente Brasil","Brasil Washington C. A. Júnior","Brígida de Samora Mora","Belderagas Piruégas de","Alfim Cerqueira Borges Cabral","Bucetildes","Cafiaspirina Cruz","Capote Valente e Marimbondo da Trindade","Caius Marcius Africanus","Carabino Tiro Certo","Carlos Alberto Santíssimo Sacramento","Cantinho da Vila Alencar da Corte Real Sampaio","Carneiro de Souza e Faro","Caso Raro Yamada","Céu Azul do Sol Poente","Chananeco Vargas da Silva","Chevrolet da Silva Ford","Cincero do Nascimento","Cinconegue Washington Matos","Clarisbadeu Braz da Silva","Colapso Cardíaco da Silva","Comigo é Nove na Garrucha Trouxada","Confessoura Dornelles","Crisoprasso Compasso","Danúbio Tarada Duarte","Esdras Esdron Eustaquio Obirapitanga","Esparadrapo Clemente de Sá","Espere em Deus Mateus","Estácio Ponta Fina Amolador","Éter Sulfúrico Amazonino Rios","Excelsa Teresinha do Menino Jesus da Costa e Silva","Faraó do Egito Sousa","Fedir Lenho","Felicidade do Lar Brasileiro","Finólila Piaubilina","Flávio Cavalcante Rei da Televisão","Francisco Notório Milhão","Francisco Zebedeu Sanguessuga","Francisoreia Doroteia Dorida","Fridundino Eulâmpio","Gigle Catabriga","Graciosa Rodela D'alho","Heubler Janota","Hidráulico Oliveira","Himineu Casamenticio das Dores Conjugais","Holofontina Fufucas","Homem Bom da Cunha Souto Maior","Horinando Pedroso Ramos","Hugo Madeira de Lei Aroeiro","Hypotenusa Pereira","Ilegível Inilegível","Inocêncio Coitadinho","Isabel Defensora de Jesus","Izabel Rainha de Portugal","Janeiro Fevereiro de Março Abril","João Bispo de Roma","João Cara de José","João Cólica","João da Mesma Data","João de Deus Fundador do Colto","João Meias de Golveias","João Pensa Bem","João Sem Sobrenome","Joaquim Pinto Molhadinho","José Amâncio e Seus Trinta e Nove","José Casou de Calças Curtas","José Catarrinho","José Machuca","José Maria Guardanapo","José Padre Nosso","José Teodoro Pinto Tapado","José Xixi","Jovelina Ó Rosa Cheirosa","Jotacá Dois Mil e Um Juana Mula","Júlio Santos Pé-Curto","Justiça Maria de Jesus","Lança Perfume Rodometálico de Andrade","Leão Rolando Pedreira","Leda Prazeres Amante","Letsgo Daqui (let's go)","Liberdade Igualdade","Fraternidade Nova York Rocha","Libertino Africano Nobre","Lindulfo Celidonio Calafange de Tefé","Lynildes Carapunfada Dores Fígado","Magnésia Bisurada do Patrocínio","Manganês Manganésfero Nacional","Manolo Porras y Porras","Manoel de Hora Pontual","Manoel Sovaco de Gambar","Manuel Sola de Sá Pato","Manuelina Terebentina","Capitulina de Jesus Amor Divino","Marciano Verdinho das Antenas Longas","Maria Constança Dores Pança","Maria Cristina do Pinto","Magro Maria da Cruz Rachadinho","Maria da Segunda Distração","Maria de Seu Pereira","Maria Felicidade","Maria Humilde","Maria Máquina","Maria Panela","Maria Passa Cantando","Maria Privada de Jesus","Maria Tributina Prostituta Cataerva","Maria-você-me-mata","Mário de Seu Pereira","Meirelaz Assunção","Mijardina Pinto","Mimaré Índio Brazileiro de Campos","Ministéio Salgado","Naida Navinda Navolta Pereira","Napoleão Estado do Pernambuco","Napoleão Sem Medo e Sem Mácula","Natal Carnaval","Natanael Gosmoguete de Souza","Necrotério Pereira da Silva","Novelo Fedelo","Oceano Atlântico Linhares","Olinda Barba de Jesus","Orlando Modesto Pinto","Orquerio Cassapietra","Otávio Bundasseca","Pacífico Armando Guerra","Padre Filho do Espírito Santo Amém","Pália Pélia Pólia Púlia dos Guimarães Peixoto","Paranahyba Pirapitinga Santana","Penha Pedrinha Bonitinha da Silva"};
    private String[] name_subjects ={" Álgebra", "Algoritmia e Programação", "Circuitos Elétricos e Eletrónicos", " Matemática I", "Projeto de Engenharia", "Sistemas Digitais","Arquitetura de Computadores", "Fundamentos de Desenvolvimento de Software", "Fundamentos de Telecomunicações", "Matemática II", " Microprocessadores", "Sistemas de Eletrónica Analógica"};
    private String[] initial_subjects = {"ALGB", "APROG", "CIRCE", "MATE1", "PROJE", "SISDIG", "ARQCP", "FSOFT", "FTELC", "MATE2", "MCROP", "SISEA"};

    private Date genDate(){
        Random gen = new Random(System.currentTimeMillis());

        int day = 1 + (gen.nextInt(Integer.MAX_VALUE) % 27);
        int month = 1 + (gen.nextInt(Integer.MAX_VALUE) % 12);
        int year = 1970 + (gen.nextInt(Integer.MAX_VALUE) % 40);
        Date dt = new Date(day,month,year);
        return dt;
    }

    private void  insertSubjects(SubjectContainer container){
        for (int  i = 0; i < this.name_subjects.length;i++){
            Subject obj = new Subject(this.initial_subjects[i],this.name_subjects[i]);
            try{
                container.add(obj);
            }catch(DuplicatedDataException e){
                //do nothing
            }
        }
    }

    private void  insertStudents(StudentContainer container){
        for (int i = 0; i < name_students.length;i++){
            Date dt = genDate();
            Student obj = new Student(name_students[i],dt);
            container.add(obj);
        }
    }

    private void  insertInstructors(InstructorContainer container){
        for (int i = 0; i < name_profs.length;i++){
            Instructor obj = new Instructor(initial_profs[i],name_profs[i]);
            try{
                container.add(obj);
            }catch(DuplicatedDataException e){
                //do nothing
            }
        }
    }

    private Subject  getRandomSubject(SubjectContainer subjects){
        Random gen = new Random(System.currentTimeMillis());
        List<Subject> listSubject = subjects.getAll();
        int is = gen.nextInt(Integer.MAX_VALUE) % listSubject.size();
        String initials = listSubject.get(is).getInitials();
        Subject  ptr = subjects.get(initials);
        return ptr;
    }
    private void  insertEnrolls(StudentContainer students, SubjectContainer subjects, EnrollContainer  container){
        Random gen = new Random(System.currentTimeMillis());
        List<Student> listStudent = students.getAll();
        for(Student student: listStudent){

            int n = 1 + gen.nextInt(Integer.MAX_VALUE) % ENROLLS_NR;
            for(int i = 0; i < n; i++){
                Subject  subject = getRandomSubject(subjects);
                int grade = 10 + gen.nextInt(Integer.MAX_VALUE) % 11;
                try{
                    Enroll enroll = new Enroll(grade, subject, student);
                    container.add(enroll);
                }catch (DuplicatedDataException e){
                }/*
			catch (...) {
                    "Catch anything";
                }*/
            }
        }
    }

    private void  insertLectures(SubjectContainer  subjects, InstructorContainer  instructors ){
        Random gen = new Random(System.currentTimeMillis());
        List<Instructor> listInstructor = instructors.getAll();
        for (Instructor instructor: listInstructor){
            Instructor  ptr = instructors.get(instructor.getInitials());
            LectureContainer container = ptr.getLectures();
            int n = 1 + gen.nextInt() % LECTURES_NR;
            for(int i = 0; i < n; i++){
                Subject  subject = getRandomSubject(subjects);
                try{
                    Lecture lecture = new Lecture(subject);
                    container.add(lecture);
                }catch (DuplicatedDataException e){
                }
            }
        }
    }

    public void  generateData(School school){
        insertSubjects(school.getSubjectContainer());
        insertStudents(school.getStudentContainer());
        insertInstructors(school.getInstructorContainer());
        insertEnrolls(school.getStudentContainer(), school.getSubjectContainer(),school.getEnrollContainer());
        insertLectures( school.getSubjectContainer(), school.getInstructorContainer());



    }
}
